/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.quantumdatasdk;

import com.quantumdata.quantumdatasdk.CheckExistence;
import com.quantumdata.quantumdatasdk.PromptForUpgrade;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

public class HandleExistingSDK {
    private static final long serialVersionUID = 923430910569838862L;
    private JFrame parentFrame;
    private static String sdkLocation;

    public HandleExistingSDK(JFrame jFrame) {
        this.parentFrame = jFrame;
    }

    protected void finalize() {
        this.parentFrame = null;
    }

    public int run() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Select QuantumData SDK Location");
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setToolTipText("Enter QuantumData SDK Location");
        jFileChooser.requestFocusInWindow();
        int n = jFileChooser.showDialog(this.parentFrame, "Select");
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            sdkLocation = file.getAbsolutePath();
            return this.verifySDKContents(sdkLocation);
        }
        return 0;
    }

    private int verifySDKContents(String string) {
        if (CheckExistence.isSDKLatest(string)) {
            return 2;
        }
        return PromptForUpgrade.run(this.parentFrame);
    }

    public static void setSDKLocation(String string) {
        sdkLocation = string;
    }

    public static String getSDKLocation() {
        return sdkLocation;
    }
}

